--[[----------------------------------------------------------------------------

(C) 2020 JaSoSe 
  Jakub Serych, serych@panska.cz http://jakub.serych.cz
 All Rights Reserved
 
 Plugin uses libary: 
    Simple JSON encoding and decoding in pure Lua.
    
    Copyright 2010-2017 Jeffrey Friedl
    http://regex.info/blog/
    Latest version: http://regex.info/blog/lua/json

--------------------------------------------------------------------------------

Info.lua
Summary information for NOise REduction PREsets plug-in.

Adds menu items to Lightroom.

------------------------------------------------------------------------------]]

return {
	
	LrSdkVersion = 3.0,
	LrSdkMinimumVersion = 1.3, -- minimum SDK version required by this plug-in

	LrToolkitIdentifier = 'com.adobe.lightroom.sdk',

	LrPluginName = LOC "$$$/NoRePre/PluginName=NOise REduction PREsets",
	
	-- Add the menu item to the File menu.
	
	LrExportMenuItems = {
		title = "NOise REduction PREsets",
		file = "norepre.lua",
	},

	-- Add the menu item to the Library menu.
	
	LrLibraryMenuItems = {
	    {
		    title = "NOise REduction PREsets",
		    file = "norepre.lua",
	   },
	},
	VERSION = { major=0, minor=9, revision=5, build="- 2020-01-09", },

}
--[[ Versions

    -- 0.9.5 2020-01-09 Small bugs repaired, initial directory = _Plugin.path\settings
    -- 0.9.4 2020-01-07 Middle ISO calculation lin -> log
    -- 0.9.2 2020-01-05 Functional version vith log - lin slider
    -- 0.9.2 2020-01-02 Version with log checkboxes
    -- 0.9.1 2019-12-28 First partly functional version
]]

	
